//----------------------------------------------------------------------------//
//- CadArtikelCodeAnzeige.pas ------------------------------------------------//
//----------------------------------------------------------------------------//

//- Beschreibung -------------------------------------------------------------//
// Anzeige des Artikelcodes whrend der Eingabe                               //
//----------------------------------------------------------------------------//

unit CadArtikelCodeAnzeige;

//------------------------------------------------------------------------------

interface

//------------------------------------------------------------------------------

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, CaoCheck, ExtCtrls;

//------------------------------------------------------------------------------

type
  TCaDlgArtikelCodeAnzeige = class(TForm)
    m_EdtNummer        : TEdit;
    m_TimCodeAnzeige   : TTimer;

    //--------------------------------------------------------------------------

    procedure FormKeyDown        (Sender: TObject; var Key: Word; Shift: TShiftState);
    procedure EdtNummerChange    (Sender: TObject);
    procedure FormCreate         (Sender: TObject);
    procedure FormDestroy        (Sender: TObject);
    procedure TimCodeAnzeigeTimer(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);


  //----------------------------------------------------------------------------

  private
    m_obCheck       : TCaoCheck;
    function PrvGetArtikelNummer: Integer;

  //----------------------------------------------------------------------------

  public
    property ArtikelNummer: Integer read PrvGetArtikelNummer;

    //--------------------------------------------------------------------------

    function ShowModal(iFirstNumber: Integer): Integer; reintroduce;

  //----------------------------------------------------------------------------

  end;  // TCaDlgArtikelCodeAnzeige

//------------------------------------------------------------------------------

var
  CaDlgArtikelCodeAnzeige: TCaDlgArtikelCodeAnzeige;

//------------------------------------------------------------------------------

implementation

//------------------------------------------------------------------------------

{$R *.dfm}

//------------------------------------------------------------------------------

uses
  CamConst, CamTypes;

//------------------------------------------------------------------------------

function TCaDlgArtikelCodeAnzeige.ShowModal(iFirstNumber: Integer): Integer;
begin
  with m_EdtNummer do begin
    m_EdtNummer.Font.Size      := c_iGrosseSchriftgroesse;
    // Editfeld leeren
    m_EdtNummer.Clear;
    // Die Erste Nummer wurde bereits im Hautfenster eingelesen -> abfllen
    m_EdtNummer.Text           := IntToStr(iFirstNumber);
    m_EdtNummer.AutoSelect     := False;
    // Den Cursor auf die 2. Stelle setzen, da in der ersten bereits die erste Zahl steht
    m_EdtNummer.SelStart       := 2;

    Color                      := c_clFTasten;
  end; // with
  Result := inherited ShowModal;
end; // TCaDlgArtikelCodeAnzeige

//------------------------------------------------------------------------------

procedure TCaDlgArtikelCodeAnzeige.FormKeyDown(Sender: TObject; var Key: Word; Shift: TShiftState);
begin
  // Wird die ESC-Taste gedrckt, so wird die Ansicht geschlossen
  if Key = VK_ESCAPE then begin
    Close;
  end; // if
end; // TCaDlgArtikelCodeAnzeige.FormKeyDown

//------------------------------------------------------------------------------

procedure TCaDlgArtikelCodeAnzeige.EdtNummerChange(Sender: TObject);
(*
  ndert die Anzeige, so muss berprft werden, ob nur Zahlen eingegeben wurden.
  Andernfals muss das Zeichen gelscht werden.
*)
begin
  m_obCheck.EditWithNumbers(m_EdtNummer, False);
  // Sind alle Zahlen eingegeben wird nach ablauf des Timers das Fenster
  // geschlossen
  if Length(m_EdtNummer.Text) >= c_iArtikelCodeLaenge then begin
    m_EdtNummer.Enabled      := False;
    m_TimCodeAnzeige.Enabled := True;
  end; // if
end; // TCaDlgArtikelCodeAnzeige.EdtNummerChange

//------------------------------------------------------------------------------

procedure TCaDlgArtikelCodeAnzeige.FormCreate(Sender: TObject);
begin
  m_obCheck := TCaoCheck.Create;
end; // TCaDlgArtikelCodeAnzeige.FormCreate

//------------------------------------------------------------------------------

procedure TCaDlgArtikelCodeAnzeige.FormDestroy(Sender: TObject);
begin
  m_obCheck.Free;
end; // TCaDlgArtikelCodeAnzeige.FormDestroy

//------------------------------------------------------------------------------

procedure TCaDlgArtikelCodeAnzeige.TimCodeAnzeigeTimer(Sender: TObject);
(*
  Anzeige nach Ablauf des Timers schliessen
*)
begin
  Close;
  m_EdtNummer.Enabled      := True;
  m_TimCodeAnzeige.Enabled := False;
end; // TCaDlgArtikelCodeAnzeige.TimCodeAnzeigeTimer

//------------------------------------------------------------------------------

function TCaDlgArtikelCodeAnzeige.PrvGetArtikelNummer: Integer;
begin
  Result := StrToInt(m_EdtNummer.Text); 
end; // TCaDlgArtikelCodeAnzeige.PrvGetArtikelNummer

//------------------------------------------------------------------------------

procedure TCaDlgArtikelCodeAnzeige.FormClose(Sender    : TObject;
                                             var Action: TCloseAction);
begin
  // Wenn der Dialog geschlossen wird, aber das Edit keine Zahl enthlt,
  // kann es einen ungltigen Zustand geben. Aus diesem Grund wird in diesem
  // Fall das Edit mit '0' abgefllt
  if m_EdtNummer.Text = '' then begin
    m_EdtNummer.Text := '0';
  end; // if
end; // TCaDlgArtikelCodeAnzeige.FormClose

//------------------------------------------------------------------------------

end. // CadArtikelCodeAnzeige
